"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _express = _interopRequireDefault(require("express"));
var _categoriesController = require("../controllers/categories.controller.js");
var router = _express["default"].Router();
router.get('/', _categoriesController.getCategories);
router.get('/:category_id/subcategories', _categoriesController.getSubcategories);
router.get('/allsubcategories', _categoriesController.getAllSubcategories);
router.post('/', _categoriesController.createCategory);
router.post('/:category_id/subcategories', _categoriesController.createSubcategory);
router.put('/:category_id', _categoriesController.updateCategory);
router.put('/:category_id/subcategories/:subcategory_id', _categoriesController.updateSubcategory);
router["delete"]('/:category_id', _categoriesController.deleteCategory);
router["delete"]('/:category_id/subcategories/:subcategory_id', _categoriesController.deleteSubcategory);
var _default = exports["default"] = router;