"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _express = _interopRequireDefault(require("express"));
var _morgan = _interopRequireDefault(require("morgan"));
var _cors = _interopRequireDefault(require("cors"));
var _dotenv = _interopRequireDefault(require("dotenv"));
var _https = require("https");
var _fs = _interopRequireDefault(require("fs"));
var _path = _interopRequireDefault(require("path"));
var _categoriesRoutes = _interopRequireDefault(require("./routes/categories.routes.js"));
var _databaseRoutes = _interopRequireDefault(require("./routes/database.routes.js"));
// Rutas

_dotenv["default"].config();
var app = (0, _express["default"])();
var PORT = process.env.PORT || 3001;

// Middlewares
app.use((0, _morgan["default"])("dev"));
app.use(_express["default"].json());
app.use(_express["default"].urlencoded({
  extended: true
}));
app.use((0, _cors["default"])());

// Endpoints
app.use("/api/categories", _categoriesRoutes["default"]);
app.use("/api/database", _databaseRoutes["default"]);
app.get("/", function (req, res) {
  res.json({
    message: "Servidor funcionando"
  });
});
if (process.env.NODE_ENV === "development") {
  // HTTP en dev
  app.listen(PORT, "0.0.0.0", function () {
    console.log("Servidor HTTP corriendo en http://0.0.0.0:".concat(PORT));
  });
} else {
  // HTTPS en prod
  var keyPath = _path["default"].join(_path["default"].resolve(), "certs", "cert.key");
  var certPath = _path["default"].join(_path["default"].resolve(), "certs", "cert.crt");
  var httpsOptions;
  try {
    httpsOptions = {
      key: _fs["default"].readFileSync(keyPath),
      cert: _fs["default"].readFileSync(certPath)
    };
  } catch (error) {
    console.error("Error al cargar certificados SSL:", error.message);
    process.exit(1);
  }
  var httpsServer = (0, _https.createServer)(httpsOptions, app);
  httpsServer.listen(PORT, "0.0.0.0", function () {
    console.log("Servidor HTTPS corriendo en https://0.0.0.0:".concat(PORT));
  });
}