"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createTables = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _connection = require("../db/connection.js");
var createTables = exports.createTables = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])(/*#__PURE__*/_regenerator["default"].mark(function _callee(req, res) {
    var connection, table_prefix, _t;
    return _regenerator["default"].wrap(function (_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          table_prefix = req.body.table_prefix;
          _context.prev = 1;
          if (/^[a-zA-Z0-9_]+$/.test(table_prefix)) {
            _context.next = 2;
            break;
          }
          return _context.abrupt("return", res.status(400).json({
            error: "Prefijo inválido"
          }));
        case 2:
          _context.next = 3;
          return (0, _connection.getConnection)();
        case 3:
          connection = _context.sent;
          _context.next = 4;
          return connection.query("\n            CREATE TABLE IF NOT EXISTS ".concat(table_prefix, "_categories (\n                id INT NOT NULL AUTO_INCREMENT PRIMARY KEY,\n                name VARCHAR(255) NOT NULL\n            )\n        "));
        case 4:
          _context.next = 5;
          return connection.query("\n            CREATE TABLE IF NOT EXISTS ".concat(table_prefix, "_subcategories (\n                id INT NOT NULL AUTO_INCREMENT PRIMARY KEY,\n                name VARCHAR(255) NOT NULL\n            )\n        "));
        case 5:
          _context.next = 6;
          return connection.query("\n            CREATE TABLE IF NOT EXISTS ".concat(table_prefix, "_reports (\n                id INT NOT NULL AUTO_INCREMENT PRIMARY KEY,\n                year INT NOT NULL,\n                month INT NOT NULL,\n                category_id INT NOT NULL,\n                subcategory_id INT NOT NULL,\n                company_id INT NOT NULL\n            )\n        "));
        case 6:
          _context.next = 7;
          return connection.query("\n            CREATE TABLE IF NOT EXISTS ".concat(table_prefix, "_configurations (\n                id INT NOT NULL AUTO_INCREMENT PRIMARY KEY,\n                name VARCHAR(255) NOT NULL,\n                value VARCHAR(255) NOT NULL\n            )\n        "));
        case 7:
          res.status(201).json({
            message: "Tablas creadas correctamente"
          });
          _context.next = 9;
          break;
        case 8:
          _context.prev = 8;
          _t = _context["catch"](1);
          console.error('Error creando tablas:', _t);
          res.status(500).json({
            error: "Error creando tablas",
            details: _t.message
          });
        case 9:
          _context.prev = 9;
          if (connection) connection.release();
          return _context.finish(9);
        case 10:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[1, 8, 9, 10]]);
  }));
  return function createTables(_x, _x2) {
    return _ref.apply(this, arguments);
  };
}();