"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateSubcategory = exports.updateCategory = exports.getSubcategories = exports.getCategories = exports.getAllSubcategories = exports.deleteSubcategory = exports.deleteCategory = exports.createSubcategory = exports.createCategory = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _connection = require("../db/connection.js");
var getCategories = exports.getCategories = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])(/*#__PURE__*/_regenerator["default"].mark(function _callee(req, res) {
    var connection, _yield$connection$que, _yield$connection$que2, rows, _t;
    return _regenerator["default"].wrap(function (_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _context.next = 1;
          return (0, _connection.getConnection)();
        case 1:
          connection = _context.sent;
          _context.next = 2;
          return connection.query('SELECT * FROM categories');
        case 2:
          _yield$connection$que = _context.sent;
          _yield$connection$que2 = (0, _slicedToArray2["default"])(_yield$connection$que, 1);
          rows = _yield$connection$que2[0];
          res.status(200).json(rows);
          _context.next = 4;
          break;
        case 3:
          _context.prev = 3;
          _t = _context["catch"](0);
          console.error('Error obteniendo categorías:', _t);
          res.status(500).json({
            error: 'Error obteniendo categorías'
          });
        case 4:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 3]]);
  }));
  return function getCategories(_x, _x2) {
    return _ref.apply(this, arguments);
  };
}();
var getSubcategories = exports.getSubcategories = /*#__PURE__*/function () {
  var _ref2 = (0, _asyncToGenerator2["default"])(/*#__PURE__*/_regenerator["default"].mark(function _callee2(req, res) {
    var connection, category_id, _yield$connection$que3, _yield$connection$que4, rows, _t2;
    return _regenerator["default"].wrap(function (_context2) {
      while (1) switch (_context2.prev = _context2.next) {
        case 0:
          _context2.prev = 0;
          _context2.next = 1;
          return (0, _connection.getConnection)();
        case 1:
          connection = _context2.sent;
          category_id = req.params.category_id;
          _context2.next = 2;
          return connection.query("SELECT * FROM subcategories WHERE category_id = '".concat(category_id, "'"));
        case 2:
          _yield$connection$que3 = _context2.sent;
          _yield$connection$que4 = (0, _slicedToArray2["default"])(_yield$connection$que3, 1);
          rows = _yield$connection$que4[0];
          res.status(200).json(rows);
          _context2.next = 4;
          break;
        case 3:
          _context2.prev = 3;
          _t2 = _context2["catch"](0);
          console.error('Error obteniendo subcategorías:', _t2);
          res.status(500).json({
            error: 'Error obteniendo subcategorías'
          });
        case 4:
        case "end":
          return _context2.stop();
      }
    }, _callee2, null, [[0, 3]]);
  }));
  return function getSubcategories(_x3, _x4) {
    return _ref2.apply(this, arguments);
  };
}();
var getAllSubcategories = exports.getAllSubcategories = /*#__PURE__*/function () {
  var _ref3 = (0, _asyncToGenerator2["default"])(/*#__PURE__*/_regenerator["default"].mark(function _callee3(req, res) {
    var connection, _yield$connection$que5, _yield$connection$que6, rows, _t3;
    return _regenerator["default"].wrap(function (_context3) {
      while (1) switch (_context3.prev = _context3.next) {
        case 0:
          _context3.prev = 0;
          _context3.next = 1;
          return (0, _connection.getConnection)();
        case 1:
          connection = _context3.sent;
          _context3.next = 2;
          return connection.query('SELECT * FROM subcategories');
        case 2:
          _yield$connection$que5 = _context3.sent;
          _yield$connection$que6 = (0, _slicedToArray2["default"])(_yield$connection$que5, 1);
          rows = _yield$connection$que6[0];
          res.status(200).json(rows);
          _context3.next = 4;
          break;
        case 3:
          _context3.prev = 3;
          _t3 = _context3["catch"](0);
          console.error('Error obteniendo subcategorías:', _t3);
          res.status(500).json({
            error: 'Error obteniendo subcategorías'
          });
        case 4:
        case "end":
          return _context3.stop();
      }
    }, _callee3, null, [[0, 3]]);
  }));
  return function getAllSubcategories(_x5, _x6) {
    return _ref3.apply(this, arguments);
  };
}();
var createCategory = exports.createCategory = /*#__PURE__*/function () {
  var _ref4 = (0, _asyncToGenerator2["default"])(/*#__PURE__*/_regenerator["default"].mark(function _callee4(req, res) {
    var connection, _req$body, name, description, _yield$connection$que7, _yield$connection$que8, rows, _t4;
    return _regenerator["default"].wrap(function (_context4) {
      while (1) switch (_context4.prev = _context4.next) {
        case 0:
          _context4.prev = 0;
          _context4.next = 1;
          return (0, _connection.getConnection)();
        case 1:
          connection = _context4.sent;
          _req$body = req.body, name = _req$body.name, description = _req$body.description;
          _context4.next = 2;
          return connection.query("INSERT INTO categories (name, description) VALUES ('".concat(name, "', '").concat(description, "')"));
        case 2:
          _yield$connection$que7 = _context4.sent;
          _yield$connection$que8 = (0, _slicedToArray2["default"])(_yield$connection$que7, 1);
          rows = _yield$connection$que8[0];
          res.status(201).json(rows);
          _context4.next = 4;
          break;
        case 3:
          _context4.prev = 3;
          _t4 = _context4["catch"](0);
          console.error('Error creando categoría:', _t4);
          res.status(500).json({
            error: 'Error creando categoría'
          });
        case 4:
        case "end":
          return _context4.stop();
      }
    }, _callee4, null, [[0, 3]]);
  }));
  return function createCategory(_x7, _x8) {
    return _ref4.apply(this, arguments);
  };
}();
var createSubcategory = exports.createSubcategory = /*#__PURE__*/function () {
  var _ref5 = (0, _asyncToGenerator2["default"])(/*#__PURE__*/_regenerator["default"].mark(function _callee5(req, res) {
    var connection, _req$body2, name, description, category_id, _yield$connection$que9, _yield$connection$que0, rows, _t5;
    return _regenerator["default"].wrap(function (_context5) {
      while (1) switch (_context5.prev = _context5.next) {
        case 0:
          _context5.prev = 0;
          _context5.next = 1;
          return (0, _connection.getConnection)();
        case 1:
          connection = _context5.sent;
          _req$body2 = req.body, name = _req$body2.name, description = _req$body2.description, category_id = _req$body2.category_id;
          _context5.next = 2;
          return connection.query("INSERT INTO subcategories (name, description, category_id) VALUES ('".concat(name, "', '").concat(description, "', '").concat(category_id, "')"));
        case 2:
          _yield$connection$que9 = _context5.sent;
          _yield$connection$que0 = (0, _slicedToArray2["default"])(_yield$connection$que9, 1);
          rows = _yield$connection$que0[0];
          res.status(201).json(rows);
          _context5.next = 4;
          break;
        case 3:
          _context5.prev = 3;
          _t5 = _context5["catch"](0);
          console.error('Error creando subcategoría:', _t5);
          res.status(500).json({
            error: 'Error creando subcategoría'
          });
        case 4:
        case "end":
          return _context5.stop();
      }
    }, _callee5, null, [[0, 3]]);
  }));
  return function createSubcategory(_x9, _x0) {
    return _ref5.apply(this, arguments);
  };
}();
var updateCategory = exports.updateCategory = /*#__PURE__*/function () {
  var _ref6 = (0, _asyncToGenerator2["default"])(/*#__PURE__*/_regenerator["default"].mark(function _callee6(req, res) {
    var connection, _req$body3, id, name, description, _yield$connection$que1, _yield$connection$que10, rows, _t6;
    return _regenerator["default"].wrap(function (_context6) {
      while (1) switch (_context6.prev = _context6.next) {
        case 0:
          _context6.prev = 0;
          _context6.next = 1;
          return (0, _connection.getConnection)();
        case 1:
          connection = _context6.sent;
          _req$body3 = req.body, id = _req$body3.id, name = _req$body3.name, description = _req$body3.description;
          _context6.next = 2;
          return connection.query("UPDATE categories SET name = '".concat(name, "', description = '").concat(description, "' WHERE id = '").concat(id, "'"));
        case 2:
          _yield$connection$que1 = _context6.sent;
          _yield$connection$que10 = (0, _slicedToArray2["default"])(_yield$connection$que1, 1);
          rows = _yield$connection$que10[0];
          res.status(200).json(rows);
          _context6.next = 4;
          break;
        case 3:
          _context6.prev = 3;
          _t6 = _context6["catch"](0);
          console.error('Error actualizando categoría:', _t6);
          res.status(500).json({
            error: 'Error actualizando categoría'
          });
        case 4:
        case "end":
          return _context6.stop();
      }
    }, _callee6, null, [[0, 3]]);
  }));
  return function updateCategory(_x1, _x10) {
    return _ref6.apply(this, arguments);
  };
}();
var updateSubcategory = exports.updateSubcategory = /*#__PURE__*/function () {
  var _ref7 = (0, _asyncToGenerator2["default"])(/*#__PURE__*/_regenerator["default"].mark(function _callee7(req, res) {
    var connection, _req$body4, id, name, description, category_id, _yield$connection$que11, _yield$connection$que12, rows, _t7;
    return _regenerator["default"].wrap(function (_context7) {
      while (1) switch (_context7.prev = _context7.next) {
        case 0:
          _context7.prev = 0;
          _context7.next = 1;
          return (0, _connection.getConnection)();
        case 1:
          connection = _context7.sent;
          _req$body4 = req.body, id = _req$body4.id, name = _req$body4.name, description = _req$body4.description, category_id = _req$body4.category_id;
          _context7.next = 2;
          return connection.query("UPDATE subcategories SET name = '".concat(name, "', description = '").concat(description, "', category_id = '").concat(category_id, "' WHERE id = '").concat(id, "'"));
        case 2:
          _yield$connection$que11 = _context7.sent;
          _yield$connection$que12 = (0, _slicedToArray2["default"])(_yield$connection$que11, 1);
          rows = _yield$connection$que12[0];
          res.status(200).json(rows);
          _context7.next = 4;
          break;
        case 3:
          _context7.prev = 3;
          _t7 = _context7["catch"](0);
          console.error('Error actualizando subcategoría:', _t7);
          res.status(500).json({
            error: 'Error actualizando subcategoría'
          });
        case 4:
        case "end":
          return _context7.stop();
      }
    }, _callee7, null, [[0, 3]]);
  }));
  return function updateSubcategory(_x11, _x12) {
    return _ref7.apply(this, arguments);
  };
}();
var deleteCategory = exports.deleteCategory = /*#__PURE__*/function () {
  var _ref8 = (0, _asyncToGenerator2["default"])(/*#__PURE__*/_regenerator["default"].mark(function _callee8(req, res) {
    var connection, id, _yield$connection$que13, _yield$connection$que14, rows, _t8;
    return _regenerator["default"].wrap(function (_context8) {
      while (1) switch (_context8.prev = _context8.next) {
        case 0:
          _context8.prev = 0;
          _context8.next = 1;
          return (0, _connection.getConnection)();
        case 1:
          connection = _context8.sent;
          id = req.params.id;
          _context8.next = 2;
          return connection.query("DELETE FROM categories WHERE id = '".concat(id, "'"));
        case 2:
          _yield$connection$que13 = _context8.sent;
          _yield$connection$que14 = (0, _slicedToArray2["default"])(_yield$connection$que13, 1);
          rows = _yield$connection$que14[0];
          res.status(200).json(rows);
          _context8.next = 4;
          break;
        case 3:
          _context8.prev = 3;
          _t8 = _context8["catch"](0);
          console.error('Error eliminando categoría:', _t8);
          res.status(500).json({
            error: 'Error eliminando categoría'
          });
        case 4:
        case "end":
          return _context8.stop();
      }
    }, _callee8, null, [[0, 3]]);
  }));
  return function deleteCategory(_x13, _x14) {
    return _ref8.apply(this, arguments);
  };
}();
var deleteSubcategory = exports.deleteSubcategory = /*#__PURE__*/function () {
  var _ref9 = (0, _asyncToGenerator2["default"])(/*#__PURE__*/_regenerator["default"].mark(function _callee9(req, res) {
    var connection, id, _yield$connection$que15, _yield$connection$que16, rows, _t9;
    return _regenerator["default"].wrap(function (_context9) {
      while (1) switch (_context9.prev = _context9.next) {
        case 0:
          _context9.prev = 0;
          _context9.next = 1;
          return (0, _connection.getConnection)();
        case 1:
          connection = _context9.sent;
          id = req.params.id;
          _context9.next = 2;
          return connection.query("DELETE FROM subcategories WHERE id = '".concat(id, "'"));
        case 2:
          _yield$connection$que15 = _context9.sent;
          _yield$connection$que16 = (0, _slicedToArray2["default"])(_yield$connection$que15, 1);
          rows = _yield$connection$que16[0];
          res.status(200).json(rows);
          _context9.next = 4;
          break;
        case 3:
          _context9.prev = 3;
          _t9 = _context9["catch"](0);
          console.error('Error eliminando subcategoría:', _t9);
          res.status(500).json({
            error: 'Error eliminando subcategoría'
          });
        case 4:
        case "end":
          return _context9.stop();
      }
    }, _callee9, null, [[0, 3]]);
  }));
  return function deleteSubcategory(_x15, _x16) {
    return _ref9.apply(this, arguments);
  };
}();