<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);


// Habilitar CORS para cualquier origen
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");

// Manejar preflight request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

// Verificar si se recibi el prefijo
if (!isset($_POST['table_prefix']) || empty($_POST['table_prefix'])) {
    http_response_code(400);
    echo json_encode(["error" => "Debes enviar el table_prefix"]);
    exit;
}

$prefix = preg_replace("/[^a-zA-Z0-9_]/", "", $_POST['table_prefix']); // Sanitizar prefijo

// Carpeta destino
$targetDir = __DIR__ . '/images/';
if (!file_exists($targetDir)) {
    mkdir($targetDir, 0755, true);
}

// Lista de archivos esperados
$files = [
    "logo" => "{$prefix}_logo",
    "icon" => "{$prefix}_icon",
    "background" => "{$prefix}_bg"
];

$response = [];

foreach ($files as $inputName => $filePrefix) {
    if (!isset($_FILES[$inputName])) {
        $response[$inputName] = "No se recibi el archivo";
        continue;
    }

    $file = $_FILES[$inputName];
    $ext = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));

    // Validar tipos de archivo permitidos
    $allowed = ['jpg', 'jpeg', 'png', 'gif', 'webp'];
    if (!in_array($ext, $allowed)) {
        $response[$inputName] = "Tipo de archivo no permitido";
        continue;
    }

    $targetFile = $targetDir . $filePrefix . "." . $ext;

    if (move_uploaded_file($file['tmp_name'], $targetFile)) {
        $response[$inputName] = "Archivo subido correctamente: " . $filePrefix . "." . $ext;
    } else {
        $response[$inputName] = "Error al subir el archivo";
    }
}

header('Content-Type: application/json');
echo json_encode($response);
