import express from 'express';
import { getReportsByCompany, getReportsGroupedByMonthYear } from '../controllers/home.controller.js';

const router = express.Router();

/**
 * @route POST /api/home/company
 * @desc Obtiene todos los reportes (regionales y nacionales) de una empresa específica
 * @body { table_prefix: string, company_nit: string }
 */

router.post('/company', getReportsByCompany);

/**
 * @route POST /api/home/grouped
 * @desc Obtiene los reportes agrupados por mes y año (de todas las empresas)
 * @body { table_prefix: string }
 */


router.post('/grouped', getReportsGroupedByMonthYear);

export default router;
