import express from 'express';

import {
  getReportHistory,
  getEditableReports,
  deleteReportHistory,
  updateEditPermission
} from '../controllers/history.controller.js';

const router = express.Router();

router.post('/get-history', getReportHistory);
router.post('/get-editable-reports', getEditableReports);
router.post('/delete-report-history', deleteReportHistory);
router.post('/update-edit-permission', updateEditPermission);

export default router;
