import express from 'express';
import { getCategories, getSubcategories, createCategory, createSubcategory, updateCategory, updateSubcategory, deleteCategory, deleteSubcategory, getAllSubcategories } from '../controllers/categories.controller.js';

const router = express.Router();

router.post('/get-categories', getCategories);
router.get('/:category_id/subcategories', getSubcategories);
router.post('/allsubcategories', getAllSubcategories);
router.post('/', createCategory);
router.post('/:category_id/subcategories', createSubcategory);
router.put('/:category_id', updateCategory);
router.put('/:category_id/subcategories/:subcategory_id', updateSubcategory);
router.delete('/:category_id', deleteCategory);
router.delete('/:category_id/subcategories/:subcategory_id', deleteSubcategory);

export default router;