import express from "express";
import morgan from "morgan";
import cors from "cors";
import dotenv from "dotenv";
import { createServer as createHttpsServer } from "https";
import fs from "fs";
import path from "path";

import categoriesRoutes from "./routes/categories.routes.js";
import databaseRoutes from "./routes/database.routes.js";
import configRoutes from "./routes/config.routes.js"
import reportRoutes from "./routes/report.route.js"
import homeRoutes from "./routes/home.routes.js"
import HistoryRoutes from "./routes/history.routes.js"

dotenv.config();

const app = express();
const PORT = process.env.PORT || 3001;

// Middlewares
app.use(morgan("dev"));
app.use(express.json());
app.use(express.urlencoded({ extended: true }));

const corsOptions = {
  origin: "*",
  credentials: false,
};

app.use(cors(corsOptions));

// Endpoints
app.use("/api/categories", categoriesRoutes);
app.use("/api/databases", databaseRoutes);
app.use("/api/config", configRoutes);
app.use("/api/reports", reportRoutes);
app.use("/api/home", homeRoutes);
app.use("/api/history", HistoryRoutes);

app.get("/", (req, res) => {
  res.json({ message: "Servidor funcionando" });
});

// Rutas a los certificados (iguales para dev y prod)
const keyPath = path.join(path.resolve(), "certs", "cert.key");
const certPath = path.join(path.resolve(), "certs", "cert.crt");

let httpsOptions;
try {
  httpsOptions = {
    key: fs.readFileSync(keyPath),
    cert: fs.readFileSync(certPath),
  };
} catch (error) {
  console.error("Error al cargar certificados SSL:", error.message);
  process.exit(1);
}

const httpsServer = createHttpsServer(httpsOptions, app);

httpsServer.listen(PORT, "0.0.0.0", () => {
  console.log(`Servidor HTTPS corriendo en https://0.0.0.0:${PORT}`);
});
