import { getConnection } from '../db/connection.js';

export const getCategories = async (req, res) => {
  
  const { table_prefix } = req.body;
  let connection;

  if (!table_prefix) {
    return res.status(400).json({ error: "Debes enviar table_prefix" });
  }

  try {
    connection = await getConnection();
    const tableName = `${table_prefix}_categories`;

    const [rows] = await connection.query(`SELECT * FROM \`${tableName}\``);

    res.status(200).json(rows);
  } catch (error) {
    console.error("Error obteniendo categorías:", error);
    res.status(500).json({ error: "Error obteniendo categorías" });
  } finally {
    if (connection) connection.release;
  }
};
export const getAllSubcategories = async (req, res) => {

  let connection;
  const { table_prefix } = req.body;

  if (!table_prefix) {
    return res.status(400).json({ error: "Debes enviar table_prefix" });
  }

  try {
    connection = await getConnection();
    const tableName = `${table_prefix}_subcategories`;

    const [rows] = await connection.query(`SELECT * FROM \`${tableName}\``);

    res.status(200).json(rows);
  } catch (error) {
    console.error("Error obteniendo subcategorías:", error);
    res.status(500).json({ error: "Error obteniendo subcategorías" });
  } finally {
    if(connection) connection.release();
  }
};
export const getSubcategories = async (req, res) => {
  
  let connection;
  try {
    connection = await getConnection();
    const { category_id } = req.params;
    const [rows] = await connection.query(
      `SELECT * FROM subcategories WHERE category_id = '${category_id}'`
    );
    res.status(200).json(rows);
  } catch (error) {
    console.error('Error obteniendo subcategorías:', error);
    res.status(500).json({ error: 'Error obteniendo subcategorías' });
  } finally {
    if(connection) connection.release();
  }
};
export const createCategory = async (req, res) => {

  let connection;
  try {
    connection = await getConnection();
    const { name, description } = req.body;
    const [rows] = await connection.query(
      `INSERT INTO categories (name, description) VALUES ('${name}', '${description}')`
    );
    res.status(201).json(rows);
  } catch (error) {
    console.error('Error creando categoría:', error);
    res.status(500).json({ error: 'Error creando categoría' });
  } finally {
    if(connection) connection.release();
  }
};
export const createSubcategory = async (req, res) => {

  let connection;
  try {
    connection = await getConnection();
    const { name, description, category_id } = req.body;
    const [rows] = await connection.query(
      `INSERT INTO subcategories (name, description, category_id) VALUES ('${name}', '${description}', '${category_id}')`
    );
    res.status(201).json(rows);
  } catch (error) {
    console.error('Error creando subcategoría:', error);
    res.status(500).json({ error: 'Error creando subcategoría' });
  } finally {
    if(connection) connection.release();
  }
};
export const updateCategory = async (req, res) => {

  let connection;
  try {
    connection = await getConnection();
    const { id, name, description } = req.body;
    const [rows] = await connection.query(
      `UPDATE categories SET name = '${name}', description = '${description}' WHERE id = '${id}'`
    );
    res.status(200).json(rows);
  } catch (error) {
    console.error('Error actualizando categoría:', error);
    res.status(500).json({ error: 'Error actualizando categoría' });
  } finally {
    if(connection) connection.release();
  }
};
export const updateSubcategory = async (req, res) => {

  let connection;
  try {
    connection = await getConnection();
    const { id, name, description, category_id } = req.body;
    const [rows] = await connection.query(
      `UPDATE subcategories SET name = '${name}', description = '${description}', category_id = '${category_id}' WHERE id = '${id}'`
    );
    res.status(200).json(rows);
  } catch (error) {
    console.error('Error actualizando subcategoría:', error);
    res.status(500).json({ error: 'Error actualizando subcategoría' });
  } finally {
    if(connection) connection.release();
  }
};
export const deleteCategory = async (req, res) => {
  let connection;
  try {
    connection = await getConnection();
    const { id } = req.params;
    const [rows] = await connection.query(`DELETE FROM categories WHERE id = '${id}'`);
    res.status(200).json(rows);
  } catch (error) {
    console.error('Error eliminando categoría:', error);
    res.status(500).json({ error: 'Error eliminando categoría' });
  } finally {
    if(connection) connection.release();
  }
};
export const deleteSubcategory = async (req, res) => {
  let connection;
  try {
    connection = await getConnection();
    const { id } = req.params;
    const [rows] = await connection.query(`DELETE FROM subcategories WHERE id = '${id}'`);
    res.status(200).json(rows);
  } catch (error) {
    console.error('Error eliminando subcategoría:', error);
    res.status(500).json({ error: 'Error eliminando subcategoría' });
  } finally {
    if(connection) connection.release();
  }
};