import { useState } from "react";
import { useNavigate } from "react-router-dom";
import "./login.css";
import Logo from "../../assets/acopinturas.svg";
import BlurText from "../../ui/text/blur/blur";
import DarkVeil from '../../ui/background/darkveil';
import SplitText from "../../ui/text/split/split";
import { useLogin } from "./hooks/useLogin";

export default function Login() {
  const [showPassword, setShowPassword] = useState(false);
  const [username, setUsername] = useState(""); 
  const [password, setPassword] = useState("");
  const navigate = useNavigate();

  const { login, loading, error, user } = useLogin();

  const handleSubmit = async (e) => {
    e.preventDefault();

    const result = await login(username);
    if (result && result.user) {
      navigate("/reportes");
    }
  };

  return (
    <>
      <section className="login-section">
        <div className="bg-wrapper-1"></div>
        <div className="bg-wrapper">
          <DarkVeil />
        </div>
        <div className="login-wrapper">
          <form className="login-card" autoComplete="off" onSubmit={handleSubmit}>
            <picture className="logo-fixed">
              <source srcSet={Logo} type="image/svg+xml" />
              <img src={Logo} alt="Logo" />
            </picture>
            <div className="login-title">
              <BlurText
                text="Iniciar Sesión"
                delay={150}
                animateBy="words"
                direction="top"
              />
            </div>

            <label htmlFor="username" className="login-label">
              Usuario
            </label>
            <input
              id="username"
              name="username"
              type="text"
              className="login-input"
              placeholder="Usuario"
              value={username}
              onChange={(e) => setUsername(e.target.value)}
              required
            />


            <button type="submit" className="login-button" disabled={loading}>
              <span>{loading ? "Cargando..." : "Iniciar sesión"}</span>
            </button>

            {error && <p className="login-error">{error}</p>}
          </form>
        </div>
      </section>
      <section className="info-section"></section>
    </>
  );
}
