import axios from "axios";
import { useEffect, useState } from "react";

const API_URL = "https://acoplasticos.com.co:3001/api/databases/get-all-research";

const useGetAllResearchs = () => {
  const [data, setData] = useState(null);
  const [loading, setLoading] = useState(true);
  const [error, setError] = useState(null);

  useEffect(() => {
    const fetchData = async () => {
      try {
        const response = await axios.get(API_URL);
        setData(response.data);
      } catch (err) {
        console.error("Error fetching researches:", err);
        setError(err);
      } finally {
        setLoading(false);
      }
    };

    fetchData();
  }, []);

  return { data, loading, error };
};

export default useGetAllResearchs;
