import "./dashboard.css";
import { useState, useEffect } from "react";


// Components
import Home from "../../components/home/home";
import ReportForm from "../../components/report-form/report-form";
import Zones from "../../components/zones/zones";
import Configuration from "../../components/configuration/configuration";
import Administration from "../../components/administration/administration";

// User Btn
import User from "../../components/user-info/user";

import useGetConfigurations from "../../components/configuration/hooks/useGetConfigurations";

import logo from "../../assets/acopinturas.svg"

export default function Dashboard() {
  const [active, setActive] = useState("Inicio");
  const [openUserModal, setOpenUserModal] = useState(false);

  const loginResponse = localStorage.getItem("loginResponse");
  const user = loginResponse ? JSON.parse(loginResponse).user : null;

  const { data: configs, loading, error } = useGetConfigurations(user?.table_prefix);

  //! define site ico
  const [colorPrimary, setColorPrimary] = useState("#ffffffff");
  const [colorSecondary, setColorSecondary] = useState("#ffffffff");
  const [colorTertiary, setColorTertiary] = useState("#000000ff");
  const [colorQuaternary, setColorQuaternary] = useState("#ffffffff");

  useEffect(() => {
    const stored = JSON.parse(localStorage.getItem("researchColors"));
    if (stored) {
      setColorPrimary(stored.color_primary);
      setColorSecondary(stored.color_secondary);
      setColorTertiary(stored.color_tertiary);
      setColorQuaternary(stored.color_quaternary);
    }

    if (configs?.configurations) {
      const c = configs.configurations;
      const updated = {
        color_primary: c.color_primary || "#420099",
        color_secondary: c.color_secondary || "#3500AB",
        color_tertiary: c.color_tertiary || "#00007F",
        color_quaternary: c.color_quaternary || "#9577D2",
      };

      setColorPrimary(updated.color_primary);
      setColorSecondary(updated.color_secondary);
      setColorTertiary(updated.color_tertiary);
      setColorQuaternary(updated.color_quaternary);

      localStorage.setItem("researchColors", JSON.stringify(updated));
    }
  }, [configs]);

  useEffect(() => {
    const root = document.documentElement;
    root.style.setProperty("--color-primary", colorPrimary);
    root.style.setProperty("--color-secondary", colorSecondary);
    root.style.setProperty("--color-tertiary", colorTertiary);
    root.style.setProperty("--color-quaternary", colorQuaternary);
  }, [colorPrimary, colorSecondary, colorTertiary, colorQuaternary]);


  const menuItems = [
    "Inicio",
    "Reportar",
    "Salir",
  ];

  // Mapeo de opciones -> componente
  const componentsMap = {
    "Inicio": <Home />,
    "Zonas": <Zones />,
    "Reportar": <ReportForm />,
    "Configuración": <Configuration />,
    "Administracion": <Administration />,
  };

  return (
    <div className="dashboard-main">
      {/* Menú lateral */}
      <section className="left-menu">

        <picture>
          <source srcSet={logo} type="image/svg+xml" />
          <img src={logo} alt="Logo" className="logo-menu" />
        </picture>

        <div className="menu-content">
          {menuItems.map((item) => (
            <button
              key={item}
              className={active === item ? "active" : ""}
              onClick={() => {
                if (item === "Salir") {
                  console.log("Cerrar sesión...");
                } else {
                  setActive(item);
                }
              }}
            >
              {item}
            </button>
          ))}
        </div>
        <div className="user-container" onClick={() => setOpenUserModal(true)}>
          U
        </div>
        {openUserModal && (
          <div className="modal-overlay" onClick={() => setOpenUserModal(false)}>
            <div className="modal-user" onClick={(e) => e.stopPropagation()}>
              <button className="close-btn" onClick={() => setOpenUserModal(false)}>✕</button>
              <h3>Información del usuario</h3>

              <ul>
                <li><strong>ID:</strong> {user.id}</li>
                <li><strong>Usuario:</strong> {user.username}</li>
                <li><strong>Empresa:</strong> {user.company_name}</li>
                <li><strong>NIT:</strong> {user.company_nit}</li>
                <li><strong>Permisos:</strong> {user.permissions}</li>
                {/*
                  <li><strong>Prefijo tabla:</strong> {user.table_prefix}</li>
                */}
                <li><strong>Creado:</strong> {new Date(user.created_at).toLocaleString()}</li>
                <li><strong>Actualizado:</strong> {new Date(user.updated_at).toLocaleString()}</li>
              </ul>
            </div>
          </div>
        )}

      </section>

      {/* Contenido dinámico */}
      <section className="website-content">
        {componentsMap[active] || <div>Seleccione una opción</div>}
      </section>
    </div>
  );
}
