import "./zones.css";
import Caribean from "../../assets/regions/Caribbean-Colombia.webp";
import Andean from "../../assets/regions/Andean-Colombia.webp";
import Pacific from "../../assets/regions/Pacific-Colombia.webp";
import Orinoquia from "../../assets/regions/Orinoquia-Colombia.webp";
import Amazon from "../../assets/regions/Amazon-Colombia.webp";

export default function Zones() {
    const regions = [
        { name: "Región Caribe", image: Caribean },
        { name: "Región Andina", image: Andean },
        { name: "Región Pacífica", image: Pacific },
        { name: "Región Orinoquía", image: Orinoquia },
        { name: "Región Amazonía", image: Amazon },
    ];
    return (
        <div className="regions-container">
            {regions.map((region) => (
                <div key={region.name} className="regions">
                    <div className="region-name">{region.name}</div>
                    <div className="region-image">
                        <img src={region.image} alt={region.name} />
                    </div>
                </div>
            ))}
        </div>
    );
}