import * as XLSX from "xlsx";

export function generateTemplateExcel(categorias, subCategories, regiones) {
  const data = [];

  categorias.forEach((cat) => {
    const subs = subCategories.filter((s) => s.category_id === cat.id);
    subs.forEach((sub) => {
      regiones
        .filter((r) => r.id !== 6) // excluir "Revisar"
        .forEach((region) => {
          data.push({
            Región: region.nombre,
            Categoría: cat.name,
            Subcategoría: sub.name,
            "Producción (Gal)": region.id === 0 ? 0 : "",
            "Ventas (COP)": 0,
            "Ventas (Gal)": 0,
          });
        });
    });
  });

  const ws = XLSX.utils.json_to_sheet(data);
  const wb = XLSX.utils.book_new();
  XLSX.utils.book_append_sheet(wb, ws, "Plantilla Reporte");

  XLSX.writeFile(wb, "plantilla_reporte.xlsx");
}
