import { useState } from "react";
import instance from "../../../utils/axios.instance";

/**
 * Hook para actualizar el permiso de edición (edit_permission = 1)
 * en el historial de reportes de una empresa.
 */
export default function useUpdateEditPermission() {
  const [loading, setLoading] = useState(false);
  const [error, setError] = useState(null);
  const [success, setSuccess] = useState(null);

  const updateEditPermission = async ({ table_prefix, company_nit, year, month }) => {
    setLoading(true);
    setError(null);
    setSuccess(null);

    try {
      console.log("Enviando petición a /api/history/update-edit-permission:", {
        table_prefix,
        company_nit,
        year,
        month,
      });

      const res = await instance.post("/api/history/update-edit-permission", {
        table_prefix,
        company_nit,
        year,
        month,
      });

      console.log("✅ Permiso actualizado correctamente:", res.data);
      setSuccess(res.data.message || "Permiso actualizado correctamente");
      return res.data;

    } catch (err) {
      console.error("❌ Error en updateEditPermission:", err.response?.data || err.message);
      setError(err.response?.data || { error: "Error de conexión" });
      throw err;

    } finally {
      setLoading(false);
    }
  };

  return {
    updateEditPermission,
    loading,
    error,
    success,
  };
}
