import { useState, useEffect } from "react";
import instance from "../../../utils/axios.instance";

// Hook para obtener todas las subcategorías
export default function useSubCategories(tablePrefix) {
  const [subCategories, setSubCategories] = useState([]);
  const [loading, setLoading] = useState(true);
  const [error, setError] = useState(null);

  useEffect(() => {
    if (!tablePrefix) return; // no hacer nada si no hay prefijo

    const fetchSubCategories = async () => {
      setLoading(true);
      try {
        const res = await instance.post("/api/categories/allsubcategories", {
          table_prefix: tablePrefix,
        });
        setSubCategories(res.data);
        setError(null);
      } catch (err) {
        console.error("Error obteniendo subcategorías:", err);
        setError(err);
      } finally {
        setLoading(false);
      }
    };

    fetchSubCategories();
  }, [tablePrefix]);

  return { subCategories, loading, error };
}
