import { useState } from "react";
import instance from "../../../utils/axios.instance";

export default function useSpecificReport() {
  const [loading, setLoading] = useState(false);
  const [error, setError] = useState(null);
  const [data, setData] = useState(null);

  /**
   * Obtener reportes específicos por empresa, mes y año
   * @param {Object} params
   * @param {string} params.table_prefix - Prefijo de la tabla
   * @param {string} params.company_nit - NIT de la empresa
   * @param {number} [params.year] - Año (opcional)
   * @param {number} [params.month] - Mes (opcional)
   */
  const fetchSpecificReport = async ({ table_prefix, company_nit, year, month }) => {
    setLoading(true);
    setError(null);

    try {
      console.log("Enviando petición a /api/reports/specific:", { table_prefix, company_nit, year, month });

      const res = await instance.post("/api/reports/specific", {
        table_prefix,
        company_nit,
        year,
        month,
      });

      console.log("Respuesta recibida desde backend (specific report):", res.data);

      setData(res.data);
      return res.data;
    } catch (err) {
      console.error("Error en fetchSpecificReport:", err.response?.data || err.message);
      setError(err.response?.data || { error: "Error de conexión" });
      throw err;
    } finally {
      setLoading(false);
    }
  };

  return {
    fetchSpecificReport,
    data,
    loading,
    error,
  };
}