import { useState } from "react";
import instance from "../../../utils/axios.instance";

export default function useHistory() {
  const [loading, setLoading] = useState(false);
  const [error, setError] = useState(null);
  const [data, setData] = useState(null);

  //Traer histórico de reportes por company_nit
  const fetchReportHistory = async ({ table_prefix, company_nit }) => {
    setLoading(true);
    setError(null);

    try {

      const res = await instance.post("/api/history/get-history", {
        table_prefix,
        company_nit,
      });

      console.log("Respuesta recibida desde backend (histórico):", res.data);

      setData(res.data);
      return res.data;
    } catch (err) {
      console.error("Error en fetchReportHistory:", err.response?.data || err.message);
      setError(err.response?.data || { error: "Error de conexión" });
      throw err;
    } finally {
      setLoading(false);
    }
  };

  return { 
    fetchReportHistory, 
    data, 
    loading, 
    error 
  };
}
