import instance from "../../../utils/axios.instance";
import { useState, useEffect } from "react";

export default function useCategories(tablePrefix) {
  const [categorias, setCategorias] = useState([]);
  const [loading, setLoading] = useState(true);
  const [error, setError] = useState(null);

  useEffect(() => {
    if (!tablePrefix) return; // no hacemos nada si no hay prefijo

    const fetchCategories = async () => {
      setLoading(true);
      try {
        const res = await instance.post("/api/categories/get-categories", { table_prefix: tablePrefix });
        setCategorias(res.data);
        setError(null);
      } catch (err) {
        console.error("Error obteniendo categorías:", err);
        setError(err);
      } finally {
        setLoading(false);
      }
    };

    fetchCategories();
  }, [tablePrefix]);

  return { categorias, loading, error };
}
