import { useState } from "react";
import instance from "../../../utils/axios.instance";

export default function useReports() {
  const [loading, setLoading] = useState(false);
  const [error, setError] = useState(null);
  const [data, setData] = useState(null);

  // Traer todos los reports (regionales + nacionales) de una empresa específica
  const fetchReportsByCompany = async ({ table_prefix, company_nit }) => {
    setLoading(true);
    setError(null);

    try {
      console.log("Enviando petición a /api/home/company:", { table_prefix, company_nit });

      const res = await instance.post("/api/home/company", {
        table_prefix,
        company_nit,
      });

      console.log("Respuesta recibida desde backend:", res.data);

      setData(res.data);
      return res.data;
    } catch (err) {
      console.error("Error en fetchReportsByCompany:", err.response?.data || err.message);
      setError(err.response?.data || { error: "Error de conexión" });
      throw err;
    } finally {
      setLoading(false);
    }
  };

  //Traer reports agrupados por mes y año de todas las empresas
  const fetchReportsGrouped = async ({ table_prefix }) => {
    setLoading(true);
    setError(null);

    try {
      console.log("Enviando petición a /api/home/grouped:", { table_prefix });

      const res = await instance.post("/api/home/grouped", {
        table_prefix,
      });

      console.log("Respuesta recibida (agrupados):", res.data);

      setData(res.data);
      return res.data;
    } catch (err) {
      console.error("Error en fetchReportsGrouped:", err.response?.data || err.message);
      setError(err.response?.data || { error: "Error de conexión" });
      throw err;
    } finally {
      setLoading(false);
    }
  };

  return { 
    fetchReportsByCompany, 
    fetchReportsGrouped, 
    data, 
    loading, 
    error 
  };
}
