import { useState } from "react";
import instance from "../../../utils/axios.instance";

export default function useSaveSubcategory() {
  const [loading, setLoading] = useState(false);
  const [error, setError] = useState(null);
  const [data, setData] = useState(null);

  const saveSubcategory = async ({ table_prefix, name, category_id }) => {
    setLoading(true);
    setError(null);

    try {
      const res = await instance.post("/api/config/save-subcategory", {
        table_prefix,
        name,
        category_id,
      });

      setData(res.data);
      return res.data;
    } catch (err) {
      setError(err.response?.data || { error: "Error de conexión" });
      throw err;
    } finally {
      setLoading(false);
    }
  };

  return { saveSubcategory, data, loading, error };
}
