import { useState } from "react";
import instance from "../../../utils/axios.instance";

export default function useSaveColors() {
  const [loading, setLoading] = useState(false);
  const [error, setError] = useState(null);
  const [data, setData] = useState(null);

  const saveColors = async ({ table_prefix, color_primary, color_secondary, color_tertiary, color_quaternary }) => {
    setLoading(true);
    setError(null);

    try {
      const res = await instance.post("/api/config/save-colors", {
        table_prefix,
        color_primary,
        color_secondary,
        color_tertiary,
        color_quaternary,
      });

      setData(res.data);
      return res.data;
    } catch (err) {
      setError(err.response?.data || { error: "Error de conexión" });
      throw err;
    } finally {
      setLoading(false);
    }
  };

  return { saveColors, data, loading, error };
}
