// hooks/useGetConfigurations.js
import { useState, useEffect } from "react";
import instance from "../../../utils/axios.instance";

export default function useGetConfigurations(table_prefix) {
  const [data, setData] = useState(null);
  const [loading, setLoading] = useState(false);
  const [error, setError] = useState(null);

  useEffect(() => {
    if (!table_prefix) return;

    const fetchConfigs = async () => {
      setLoading(true);
      setError(null);
      try {
        const res = await instance.post("/api/config/get-configurations", {
          table_prefix,
        });
        setData(res.data.data); // el objeto { config: value }
      } catch (err) {
        setError(err.response?.data || { error: "Error de conexión" });
      } finally {
        setLoading(false);
      }
    };

    fetchConfigs();
  }, [table_prefix]);

  return { data, loading, error };
}
