import { useState } from "react";
import instance from "../../../utils/axios.instance";

export default function useSaveCategory() {
  const [loading, setLoading] = useState(false);
  const [error, setError] = useState(null);
  const [data, setData] = useState(null);

  const saveCategory = async ({ table_prefix, name }) => {
    setLoading(true);
    setError(null);

    try {
      const res = await instance.post("/api/config/save-category", {
        table_prefix,
        name,
      });

      setData(res.data);
      return res.data;
    } catch (err) {
      setError(err.response?.data || { error: "Error de conexión" });
      throw err;
    } finally {
      setLoading(false);
    }
  };

  return { saveCategory, data, loading, error };
}
