import { useState } from "react";
import instance from "../../../utils/axios.instance";

export default function useEditableReports() {
  const [data, setData] = useState(null);
  const [loading, setLoading] = useState(false);
  const [error, setError] = useState(null);

  const fetchEditableReports = async ({ table_prefix, company_nit }) => {
    setLoading(true);
    setError(null);

    try {
      console.log("Enviando petición a /api/history/get-editable-reports:", {
        table_prefix,
        company_nit,
      });

      const res = await instance.post("/api/history/get-editable-reports", {
        table_prefix,
        company_nit,
      });

      console.log("Respuesta recibida (reportes editables):", res.data);

      setData(res.data);
      return res.data;
    } catch (err) {
      console.error("Error en fetchEditableReports:", err.response?.data || err.message);
      setError(err.response?.data || { error: "Error de conexión" });
      throw err;
    } finally {
      setLoading(false);
    }
  };

  return { fetchEditableReports, data, loading, error };
}
