import { useState } from "react";
import instance from "../../../utils/axios.instance";

export default function useDeleteReportHistory() {
  const [loading, setLoading] = useState(false);
  const [error, setError] = useState(null);
  const [response, setResponse] = useState(null);

  const deleteReportHistory = async ({ table_prefix, company_nit, year, month }) => {
    setLoading(true);
    setError(null);

    try {
      console.log("Enviando petición a /api/history/delete-report-history:", {
        table_prefix,
        company_nit,
        year,
        month,
      });

      const res = await instance.post("/api/history/delete-report-history", {
        table_prefix,
        company_nit,
        year,
        month,
      });

      console.log("🗑️ Respuesta desde backend (eliminación):", res.data);

      setResponse(res.data);
      return res.data;
    } catch (err) {
      console.error("Error en deleteReportHistory:", err.response?.data || err.message);
      setError(err.response?.data || { error: "Error de conexión" });
      throw err;
    } finally {
      setLoading(false);
    }
  };

  return {
    deleteReportHistory,
    response,
    loading,
    error,
  };
}
